// dBm-Meter-AD8318.ino
// -----------------------------------------------------------------------
#include <EEPROM.h>                                       // use libraries
#include <LiquidCrystal.h>
//#include <math.h>

#define LEFT 1                // define keys
#define RIGHT 2
#define UP 3
#define DOWN 4
// #define SELECT 5                                               not used

//--------- custom chacters made using   https://omerk.github.io/lcdchargen

byte char_up_down[8]    = {0b00100,0b01010,0b10001,0b00000,0b10001,0b01010,
                           0b00100,0b00000};

byte char_left_right[8] = {0b10000,0b01000,0b00100,0b01001,0b10010,0b00100,
                           0b00010,0b00001};
// ------------------------------------------------------------------------ 
//  allocate arduino nano pins to LCD diplay pins(rs,enable,DB4,DB5,DB6,DB7)
    LiquidCrystal lcd(8, 9, 4, 5, 6, 7);

byte  att_values[] = {0,3,6,10,20,30,40,50,60};
byte  key_value ,   att_dB , att , att_prev , fff ,  fff_prev, iii ;
char  float_string[7]; 
int   key_value_A1,   error_limit_LOW  ,error_limit_HIGH; 
float A1_volt,  level_dBm,  power_W,  f_ghz,  mmm,  ccc ;
// ------------------------------------------------------------------------
void setup()
{   
    lcd.begin(16, 2);  
    analogReference (DEFAULT) ;                                      // +5V
    
    lcd.createChar(0, char_up_down);
    lcd.createChar(1, char_left_right);
    
    lcd.clear();  
    lcd.print(" HF-LEVELMETER  ");                           //50\xF4");  
    lcd.setCursor(0,1);  
    lcd.print("(c)2017 by DC5ZM");
    delay(3000);

    fff = EEPROM.read(0);
    att = EEPROM.read(1);
}
// ========================================================================
void loop()
{  
    check_status_of_keys();                         // on LCD-Keypad-Shield

    select_attenuator_used();                        // on input SMA socket

    select_calibration_curve();               // based on AD8318 data sheet
  
    process_voltage_vout();                             // of module AD8318

    calculate_level_and_power();                         // of measurements
     
    display_measured_values();                      // on LCD-Keypad-Shield
} 
// ========================================================================
void check_status_of_keys()
{
    key_value = analogRead(A0)/10;                      // test key pressed

    if (key_value <5)                    key_value = RIGHT;
    if (key_value >5  && key_value<15 )     key_value = UP;
    if (key_value>20  && key_value<30 )   key_value = DOWN;
    if (key_value>35  && key_value<45 )   key_value = LEFT;  
//  if (key_value>60  && key_value<70 ) key_value = SELECT;        not used

    while (analogRead(A0)/10 < 100);               // wait for key released
}
// ------------------------------------------------------------------------
void select_attenuator_used()
{
    if(key_value == DOWN)  att--;         // att = counter index, decrement
    if(key_value == UP)    att++;                          // increment att
    if(att > 200) att = 0;            // handle underflow of data type byte
    if(att > 8) att = 8;                          // handle overflow of att
    att_dB = att_values[att];

    if(att_prev != att)                           // if att has changed ...
    {   EEPROM.write(1,att);          // save selected attenuator in EEPROM
        att_prev = att;
    }
}
// ------------------------------------------------------------------------
void select_calibration_curve()
{
    if(key_value == LEFT)  fff--;         // fff = counter index, decrement
    if(key_value == RIGHT) fff++;                          // increment fff
    if(fff < 1) fff = 1;                         // handle underflow of fff
    if(fff > 6) fff = 6;                          // handle overflow of fff

    if(fff==1)  {f_ghz = 0.9; AD8318_use_curve_0ghz9();}          // select
    if(fff==2)  {f_ghz = 1.9; AD8318_use_curve_1ghz9();}     // calibration
    if(fff==3)  {f_ghz = 2.2; AD8318_use_curve_2ghz2();}           // curve
    if(fff==4)  {f_ghz = 3.6; AD8318_use_curve_3ghz6();}
    if(fff==5)  {f_ghz = 5.8; AD8318_use_curve_5ghz8();}
    if(fff==6)  {f_ghz = 8.0; AD8318_use_curve_8ghz0();}

    if(fff_prev != fff)                           // if fff has changed ...
    {   EEPROM.write(0,fff);     // save selected frequency curve in EEPROM
        fff_prev = fff;
    }
} 
// ------------------------------------------------------------------------   
void process_voltage_vout()
{ 
    A1_volt  =  analogRead(A1);                                  // read 1x
    for(iii=0;iii<=8; iii++)                         // iii = counter index      
        A1_volt  =  A1_volt + analogRead(A1);                    // read 9x

    A1_volt  =  A1_volt/2046 ;    // calculate average value of 10 readings 
}                                                      // 2046 = 10*1023/5V  
// ------------------------------------------------------------------------
void  calculate_level_and_power()

{           // straight line equation: y = mmm*x + ccc -> x = (y - ccc)/mmm
    level_dBm = -(A1_volt-ccc)/mmm + att_dB;
    level_dBm = floor(level_dBm + 0.5);     // round and convert to integer
  
    power_W = pow(10,level_dBm/10);                    // convert dBm to mW 
}
// ------------------------------------------------------------------------
void display_measured_values()
{ 
    lcd.setCursor(0,0);                                    // go to line #1
    dtostrf(level_dBm,3,0,float_string);         //convert float to string
    lcd.print("L=");      
    lcd.print(float_string);
    lcd.print("dBm ");
      
    lcd.print("AT");      
    dtostrf(att_dB,2,0,float_string);       
    lcd.print(float_string);
    lcd.print("dB");
    lcd.write(byte(0));                         // custom made char_up_down

    lcd.setCursor(0,1);                                    // go to line #2
    lcd.print("P=");
    select_subunit_of_power();

    dtostrf(f_ghz,3,1,float_string);       
    lcd.print(float_string);
    lcd.print("GHz");
    lcd.write(byte(1));                     // custom made char_left_right

    if(level_dBm < error_limit_LOW || level_dBm > error_limit_HIGH)
    { delay(300); lcd.setCursor(0,0); lcd.print(" ");delay(300);}
}
// ------------------------------------------------------------------------
void AD8318_use_curve_0ghz9()
{   mmm = 0.025;          // values for straight line equation: mmm = slope
    ccc = 0.56;                                   // ccc = intercept y-axis
  
    error_limit_LOW = -55;         // dBm limits for acceptable error range
    error_limit_HIGH = -1;
}
// ------------------------------------------------------------------------
void AD8318_use_curve_1ghz9()
{   mmm = 0.025;
    ccc = 0.45;
    error_limit_LOW = -68;
    error_limit_HIGH = -5;
}
// ------------------------------------------------------------------------
void AD8318_use_curve_2ghz2() 
{   mmm = 0.025;
    ccc = 0.45;
    error_limit_LOW = -60;
    error_limit_HIGH = -4;
}
// ------------------------------------------------------------------------
void AD8318_use_curve_3ghz6()
{    mmm = 0.025;                                    
    ccc = 0.5;
    error_limit_LOW = -52;                      
    error_limit_HIGH = -3;
}
// ------------------------------------------------------------------------
void AD8318_use_curve_5ghz8()
{   mmm = 0.025;
    ccc = 0.63;
    error_limit_LOW = -56;
    error_limit_HIGH = 0;
}
// ------------------------------------------------------------------------
void AD8318_use_curve_8ghz0()
{    mmm = 0.025;
    ccc = 0.77;
    error_limit_LOW = -54;
    error_limit_HIGH =  0;
}
// ------------------------------------------------------------------------
void select_subunit_of_power()                // select unit: W, mW, µW, nW
{ 
    if(level_dBm <-30)
    { dtostrf(power_W*1000000,4,0,float_string);  //convert float to string
      lcd.print(float_string);
      lcd.print("nW ");
    }

    if(level_dBm >= -30 && level_dBm <0)
    { dtostrf(power_W*1000,4,0,float_string);      
      lcd.print(float_string);
      lcd.print("\xE4W ");                                   // \xE4W = µW
    } 

    if(level_dBm >=0 && level_dBm <30)
    { dtostrf(power_W,4,0,float_string);    
      lcd.print(float_string);
      lcd.print("mW "); 
    } 

    if(level_dBm >=30 && level_dBm <60)
    { dtostrf(power_W/1000,4,0,float_string);    
      lcd.print(float_string);
      lcd.print(" W ");   
    }  
}
// ------------------------------------------------------------------------
